//	TorusGamesMatteView.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import <UIKit/UIKit.h>
#import "TorusGames-Common.h"


typedef enum
{
	MatteViewPortraitLayout,
	MatteViewLandscapeLayout
} MatteViewLayoutOrientation;


@protocol TorusGamesMatteViewDelegate
- (void)matteViewDidSetLayoutOrientation:(MatteViewLayoutOrientation)aMatteViewLayoutOrientation;
@end


@interface TorusGamesMatteView : UIView

- (id)initWithDelegate:(id<TorusGamesMatteViewDelegate>)aDelegate frame:(CGRect)aFrame game:(GameType)aGame;

- (void)addMessageView:(UIView *)aMessageView;
- (void)addGameEnclosureView:(UIView *)aGameEnclosureView;
- (void)addKeyboardView:(UIView *)aKeyboardView;

- (void)setMarginTop:(CGFloat)aTopMargin bottom:(CGFloat)aBottomMargin;
- (void)layoutSubviews;
- (void)refreshLayoutForGame:(GameType)aGame;

@end
